/*
 * Decompiled with CFR 0.152.
 */
package buscript.multiverse;

import buscript.multiverse.BuscriptListener;
import buscript.multiverse.DefaultFunctions;
import buscript.multiverse.ScriptTask;
import buscript.multiverse.StringReplacer;
import buscript.multiverse.VaultListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;

public class Buscript {
    public static final String NULL = "!!NULL";
    private String target = null;
    private Plugin plugin;
    private Scriptable global;
    private Permission permissions;
    private Economy economy;
    private Chat chat;
    private File scriptFolder;
    private File scriptFile;
    private FileConfiguration scriptConfig;
    private List<Map<String, Object>> delayedReplacements = null;
    private final List<StringReplacer> stringReplacers = new ArrayList<StringReplacer>();
    private Map<String, Object> metaData = new HashMap<String, Object>();
    boolean runTasks = true;
    Map<String, List<Map<String, Object>>> delayedScripts = new HashMap<String, List<Map<String, Object>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buscript(Plugin plugin) {
        this.plugin = plugin;
        this.registerStringReplacer(new TargetReplacer(this));
        this.scriptFolder = new File(plugin.getDataFolder(), "scripts");
        if (!this.getScriptFolder().exists()) {
            this.getScriptFolder().mkdirs();
        }
        Context cx = Context.enter();
        try {
            this.global = cx.initStandardObjects();
            this.global.put("server", this.global, (Object)plugin.getServer());
            this.global.put("plugin", this.global, (Object)plugin);
            this.global.put("metaData", this.global, this.metaData);
            this.global.put("NULL", this.global, (Object)NULL);
        }
        finally {
            Context.exit();
        }
        this.addScriptMethods(new DefaultFunctions(this));
        this.setupVault();
        plugin.getServer().getPluginManager().registerEvents((Listener)new VaultListener(this), plugin);
        this.initData();
        ScriptTask scriptTask = new ScriptTask(this);
        scriptTask.start();
        plugin.getServer().getPluginManager().registerEvents((Listener)new BuscriptListener(this), plugin);
    }

    private void initData() {
        this.scriptFile = new File(this.getScriptFolder(), "scripts.bin");
        this.scriptConfig = YamlConfiguration.loadConfiguration((File)this.scriptFile);
        ConfigurationSection scripts = this.scriptConfig.getConfigurationSection("scripts");
        if (scripts != null) {
            for (String player : scripts.getKeys(false)) {
                ArrayList playerScripts = new ArrayList();
                this.delayedScripts.put(player, playerScripts);
                for (Object scriptObj : scripts.getList(player)) {
                    if (!(scriptObj instanceof Map)) continue;
                    Map scriptMap = (Map)scriptObj;
                    HashMap<String, Number> script = new HashMap<String, Number>(2);
                    for (Object keyObj : scriptMap.keySet()) {
                        if (keyObj.toString().equals("time")) {
                            try {
                                script.put(keyObj.toString(), Long.valueOf(scriptMap.get(keyObj).toString()));
                            }
                            catch (NumberFormatException e) {
                                this.getPlugin().getLogger().warning("Script data error, time reset");
                                script.put(keyObj.toString(), 0);
                            }
                            continue;
                        }
                        script.put(keyObj.toString(), (Number)scriptMap.get(keyObj));
                    }
                    playerScripts.add(script);
                }
            }
        }
    }

    void setupVault() {
        RegisteredServiceProvider chatProvider;
        RegisteredServiceProvider economyProvider;
        if (this.getPlugin().getServer().getPluginManager().getPlugin("Vault") == null) {
            return;
        }
        RegisteredServiceProvider permissionProvider = this.getPlugin().getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider != null) {
            this.permissions = (Permission)permissionProvider.getProvider();
        }
        if ((economyProvider = this.getPlugin().getServer().getServicesManager().getRegistration(Economy.class)) != null) {
            this.economy = (Economy)economyProvider.getProvider();
        }
        if ((chatProvider = this.getPlugin().getServer().getServicesManager().getRegistration(Chat.class)) != null) {
            this.chat = (Chat)chatProvider.getProvider();
        }
        this.updateVaultInGlobalScope();
    }

    void disableVault() {
        this.permissions = null;
        this.economy = null;
        this.chat = null;
        this.updateVaultInGlobalScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVaultInGlobalScope() {
        Context.enter();
        try {
            this.global.put("permissions", this.global, (Object)this.permissions);
            this.global.put("chat", this.global, (Object)this.chat);
            this.global.put("economy", this.global, (Object)this.economy);
        }
        finally {
            Context.exit();
        }
    }

    void saveData() {
        this.scriptConfig.set("scripts", this.delayedScripts);
        try {
            this.scriptConfig.save(this.scriptFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save script data: " + e.getMessage());
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Scriptable getGlobalScope() {
        return this.global;
    }

    public Permission getPermissions() {
        return this.permissions;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public Chat getChat() {
        return this.chat;
    }

    public String getTarget() {
        return this.target;
    }

    public File getScriptFolder() {
        return this.scriptFolder;
    }

    public void setScriptFolder(File folder) {
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("folder must be a directory!");
        }
        this.scriptFolder = folder;
    }

    public String stringReplace(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        String result = string;
        if (this.delayedReplacements != null) {
            for (Map<String, Object> replacement : this.delayedReplacements) {
                Object regex = replacement.get("regex");
                Object replace = replacement.get("replace");
                if (regex == null) continue;
                if (replace == null) {
                    replace = NULL;
                }
                result = result.replaceAll(regex.toString(), replace.toString());
            }
        } else {
            for (StringReplacer r : this.stringReplacers) {
                String regex = r.getRegexString();
                if (regex == null) continue;
                String replace = r.getReplacement();
                if (replace == null) {
                    replace = NULL;
                }
                result = result.replaceAll(regex, replace);
            }
        }
        result = ChatColor.translateAlternateColorCodes((char)'&', (String)result);
        return result;
    }

    public void registerStringReplacer(StringReplacer replacer) {
        Iterator<StringReplacer> it = this.stringReplacers.iterator();
        while (it.hasNext()) {
            StringReplacer r = it.next();
            if (!r.getRegexString().equals(replacer.getRegexString())) continue;
            it.remove();
        }
        this.stringReplacers.add(replacer);
    }

    public void addScriptMethod(String name, Method method, Scriptable obj) {
        FunctionObject scriptMethod = new FunctionObject(name, method, obj);
        this.global.put(name, this.global, (Object)scriptMethod);
    }

    public void addScriptMethods(String[] names, Scriptable obj) {
        for (Method method : obj.getClass().getDeclaredMethods()) {
            for (String name : names) {
                if (!method.getName().equals(name)) continue;
                this.addScriptMethod(name, method, obj);
            }
        }
    }

    public void addScriptMethods(Scriptable obj) {
        for (Method method : obj.getClass().getDeclaredMethods()) {
            this.addScriptMethod(method.getName(), method, obj);
        }
    }

    void executeDelayedScript(File scriptFile, List<Map<String, Object>> replacements, Map<String, Object> data) {
        if (data != null) {
            this.metaData = data;
        }
        this.delayedReplacements = replacements;
        this.executeScript(scriptFile, null, null);
        this.delayedReplacements = null;
    }

    public void executeScript(File scriptFile) {
        this.executeScript(scriptFile, null, null);
    }

    public void executeScript(File scriptFile, Player executor) {
        this.executeScript(scriptFile, null, executor);
    }

    public void executeScript(File scriptFile, String target) {
        this.executeScript(scriptFile, target, null);
    }

    public void executeScript(File scriptFile, String target, Player executor) {
        this.target = target;
        this.runScript(scriptFile, executor);
        this.target = null;
        this.metaData.clear();
    }

    public void scheduleScript(File scriptFile, long delay) {
        this.scheduleScript(scriptFile, null, delay);
    }

    public void scheduleScript(File scriptFile, String target, long delay) {
        List<Map<String, Object>> playerScripts;
        if (target == null) {
            target = NULL;
        }
        if ((playerScripts = this.delayedScripts.get(target)) == null) {
            playerScripts = new ArrayList<Map<String, Object>>();
            this.delayedScripts.put(target, playerScripts);
        }
        HashMap<String, Object> script = new HashMap<String, Object>(2);
        script.put("time", System.currentTimeMillis() + delay);
        script.put("file", scriptFile.toString());
        ArrayList replacements = new ArrayList(this.stringReplacers.size());
        for (StringReplacer r : this.stringReplacers) {
            String var;
            String replace;
            HashMap<String, String> replacement = new HashMap<String, String>(2);
            String regex = r.getRegexString();
            if (regex != null) {
                replacement.put("regex", regex);
            }
            if ((replace = r.getReplacement()) != null) {
                replacement.put("replace", replace);
            }
            if ((var = r.getGlobalVarName()) != null) {
                replacement.put("var", var);
            }
            replacements.add(replacement);
        }
        script.put("replacements", replacements);
        script.put("metaData", new HashMap<String, Object>(this.metaData));
        playerScripts.add(script);
        this.saveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runScript(File script, Player executor) {
        Context cx = Context.enter();
        try {
            if (this.delayedReplacements != null) {
                for (Map map : this.delayedReplacements) {
                    Object var = map.get("var");
                    Object replace = map.get("replace");
                    if (var == null) continue;
                    if (replace == null) {
                        replace = NULL;
                    }
                    this.global.put(var.toString(), this.global, replace);
                }
            } else {
                for (StringReplacer stringReplacer : this.stringReplacers) {
                    String var = stringReplacer.getGlobalVarName();
                    String replace = stringReplacer.getReplacement();
                    if (var == null) continue;
                    if (replace == null) {
                        replace = NULL;
                    }
                    this.global.put(var, this.global, (Object)replace);
                }
            }
            this.global.put("metaData", this.global, this.metaData);
            FileReader reader = null;
            try {
                reader = new FileReader(script);
                cx.evaluateReader(this.global, reader, script.toString(), 1, null);
            }
            catch (Exception exception) {
                this.getPlugin().getLogger().warning("Error running script: " + exception.getMessage());
                if (executor != null) {
                    executor.sendMessage("Error running script: " + exception.getMessage());
                }
            }
            finally {
                if (reader != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            Context.exit();
        }
    }

    public void clearScheduledScripts(String target) {
        this.delayedScripts.remove(target);
        this.saveData();
    }

    private static class TargetReplacer
    implements StringReplacer {
        private Buscript buscript;

        private TargetReplacer(Buscript buscript) {
            this.buscript = buscript;
        }

        @Override
        public String getRegexString() {
            return "%target%";
        }

        @Override
        public String getReplacement() {
            return this.buscript.getTarget();
        }

        @Override
        public String getGlobalVarName() {
            return "target";
        }
    }
}

