/*
 * Decompiled with CFR 0.152.
 */
package com.lithium3141.shellparser.states;

import com.lithium3141.shellparser.ParseException;
import com.lithium3141.shellparser.states.EscapeState;
import com.lithium3141.shellparser.states.StartState;
import com.lithium3141.shellparser.states.State;
import java.util.List;

public class QuoteState
extends State {
    char quote;

    public QuoteState(char quote) {
        this.quote = quote;
    }

    @Override
    public List<String> parse(String parsing, String accumulator, List<String> parsed, State referrer) throws ParseException {
        if (parsing.length() == 0) {
            throw new ParseException("Mismatched quote character: " + this.quote);
        }
        char c = (char)parsing.getBytes()[0];
        if (c == '\\') {
            return new EscapeState().parse(parsing.substring(1), accumulator, parsed, this);
        }
        if (c == this.quote) {
            return new StartState().parse(parsing.substring(1), accumulator, parsed, this);
        }
        return new QuoteState(this.quote).parse(parsing.substring(1), accumulator + c, parsed, this);
    }
}

