/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.api.WorldPurger;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Golem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Squid;

public class SimpleWorldPurger
implements WorldPurger {
    private MultiverseCore plugin;
    private Class<Entity> ambientClass = null;

    public SimpleWorldPurger(MultiverseCore plugin) {
        this.plugin = plugin;
        try {
            Class<?> entityClass = Class.forName("org.bukkit.entity.Ambient");
            if (Entity.class.isAssignableFrom(entityClass)) {
                this.ambientClass = entityClass;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void purgeWorlds(List<MultiverseWorld> worlds) {
        if (worlds == null || worlds.isEmpty()) {
            return;
        }
        for (MultiverseWorld world : worlds) {
            this.purgeWorld(world);
        }
    }

    @Override
    public void purgeWorld(MultiverseWorld world) {
        if (world == null) {
            return;
        }
        ArrayList<String> allMobs = new ArrayList<String>(world.getAnimalList());
        allMobs.addAll(world.getMonsterList());
        this.purgeWorld(world, allMobs, !world.canAnimalsSpawn(), !world.canMonstersSpawn());
    }

    @Override
    public boolean shouldWeKillThisCreature(MultiverseWorld world, Entity e) {
        ArrayList<String> allMobs = new ArrayList<String>(world.getAnimalList());
        allMobs.addAll(world.getMonsterList());
        return this.shouldWeKillThisCreature(e, allMobs, !world.canAnimalsSpawn(), !world.canMonstersSpawn());
    }

    @Override
    public void purgeWorld(MultiverseWorld mvworld, List<String> thingsToKill, boolean negateAnimals, boolean negateMonsters, CommandSender sender) {
        if (mvworld == null) {
            return;
        }
        World world = mvworld.getCBWorld();
        if (world == null) {
            return;
        }
        int projectilesKilled = 0;
        int entitiesKilled = 0;
        boolean specifiedAll = thingsToKill.contains("ALL");
        boolean specifiedAnimals = thingsToKill.contains("ANIMALS") || specifiedAll;
        boolean specifiedMonsters = thingsToKill.contains("MONSTERS") || specifiedAll;
        List worldEntities = world.getEntities();
        ArrayList<LivingEntity> livingEntities = new ArrayList<LivingEntity>(worldEntities.size());
        ArrayList<Projectile> projectiles = new ArrayList<Projectile>(worldEntities.size());
        for (Entity entity : worldEntities) {
            if (entity instanceof Projectile) {
                Projectile p = (Projectile)entity;
                if (p.getShooter() == null) continue;
                projectiles.add((Projectile)entity);
                continue;
            }
            if (!(entity instanceof LivingEntity)) continue;
            livingEntities.add((LivingEntity)entity);
        }
        for (LivingEntity livingEntity : livingEntities) {
            if (!this.killDecision((Entity)livingEntity, thingsToKill, negateAnimals, negateMonsters, specifiedAnimals, specifiedMonsters)) continue;
            Iterator it = projectiles.iterator();
            while (it.hasNext()) {
                Projectile p = (Projectile)it.next();
                if (!p.getShooter().equals(livingEntity)) continue;
                p.remove();
                it.remove();
                ++projectilesKilled;
            }
            livingEntity.remove();
            ++entitiesKilled;
        }
        if (sender != null) {
            sender.sendMessage(entitiesKilled + " entities purged from the world '" + world.getName() + "' along with " + projectilesKilled + " projectiles that belonged to them.");
        }
    }

    private boolean killDecision(Entity e, List<String> thingsToKill, boolean negateAnimals, boolean negateMonsters, boolean specifiedAnimals, boolean specifiedMonsters) {
        boolean negate = false;
        boolean specified = false;
        if (e instanceof Golem || e instanceof Squid || e instanceof Animals || this.ambientClass != null && this.ambientClass.isInstance(e)) {
            if (specifiedAnimals && !negateAnimals) {
                CoreLogging.finest("Removing an entity because I was told to remove all animals in world %s: %s", e.getWorld().getName(), e);
                return true;
            }
            if (specifiedAnimals) {
                specified = true;
            }
            negate = negateAnimals;
        } else if (e instanceof Monster || e instanceof Ghast || e instanceof Slime) {
            if (specifiedMonsters && !negateMonsters) {
                CoreLogging.finest("Removing an entity because I was told to remove all monsters in world %s: %s", e.getWorld().getName(), e);
                return true;
            }
            if (specifiedMonsters) {
                specified = true;
            }
            negate = negateMonsters;
        }
        for (String s : thingsToKill) {
            EntityType type = EntityType.fromName((String)s);
            if (type == null || !type.equals((Object)e.getType())) continue;
            specified = true;
            if (negate) break;
            CoreLogging.finest("Removing an entity because it WAS specified and we are NOT negating in world %s: %s", e.getWorld().getName(), e);
            return true;
        }
        if (!specified && negate) {
            CoreLogging.finest("Removing an entity because it was NOT specified and we ARE negating in world %s: %s", e.getWorld().getName(), e);
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldWeKillThisCreature(Entity e, List<String> thingsToKill, boolean negateAnimals, boolean negateMonsters) {
        boolean specifiedAll = thingsToKill.contains("ALL");
        boolean specifiedAnimals = thingsToKill.contains("ANIMALS") || specifiedAll;
        boolean specifiedMonsters = thingsToKill.contains("MONSTERS") || specifiedAll;
        return this.killDecision(e, thingsToKill, negateAnimals, negateMonsters, specifiedAnimals, specifiedMonsters);
    }

    @Override
    public void purgeWorld(MultiverseWorld mvworld, List<String> thingsToKill, boolean negateAnimals, boolean negateMonsters) {
        this.purgeWorld(mvworld, thingsToKill, negateAnimals, negateMonsters, null);
    }
}

