/*
 * Decompiled with CFR 0.152.
 */
package me.main__.util.SerializationConfig;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.main__.util.SerializationConfig.ChangeDeniedException;
import me.main__.util.SerializationConfig.IllegalPropertyValueException;
import me.main__.util.SerializationConfig.InstanceCache;
import me.main__.util.SerializationConfig.MissingAnnotationException;
import me.main__.util.SerializationConfig.NoSuchPropertyException;
import me.main__.util.SerializationConfig.ObjectUsingValidator;
import me.main__.util.SerializationConfig.Property;
import me.main__.util.SerializationConfig.ReflectionUtils;
import me.main__.util.SerializationConfig.Serializor;
import me.main__.util.SerializationConfig.ValidateAllWith;
import me.main__.util.SerializationConfig.Validator;
import me.main__.util.SerializationConfig.VirtualProperty;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public abstract class SerializationConfig
implements ConfigurationSerializable {
    private static final InstanceCache<Serializor<?, ?>> serializorCache = new InstanceCache();
    private static final InstanceCache<Validator<?>> validatorCache = new InstanceCache();
    private static final Map<Class<? extends SerializationConfig>, Map<String, String>> aliasMap = new WeakHashMap<Class<? extends SerializationConfig>, Map<String, String>>();
    private static Logger logger = null;
    private final Map<Field, Object> pendingVPropChanges = new HashMap<Field, Object>();
    private Object objectUsing = this;
    private Validator globalValidator = null;
    private Map<Field, Validator> validatorMap = new HashMap<Field, Validator>();

    public static void initLogging(Logger log) {
        logger = log;
    }

    public static void registerAlias(Class<? extends SerializationConfig> clazz, String alias, String property) {
        Map<String, String> myAliasMap = SerializationConfig.getAliasMap(clazz);
        myAliasMap.put(alias, property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getAliasMap(Class<? extends SerializationConfig> clazz) {
        if (!aliasMap.containsKey(clazz)) {
            Map defaultMap;
            Method defaultsMethod = null;
            try {
                defaultsMethod = clazz.getDeclaredMethod("getAliases", new Class[0]);
                defaultsMethod.setAccessible(true);
                defaultMap = (Map)defaultsMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                defaultMap = null;
            }
            finally {
                if (defaultsMethod != null) {
                    defaultsMethod.setAccessible(false);
                }
            }
            if (defaultMap == null) {
                defaultMap = new HashMap();
            }
            aliasMap.put(clazz, defaultMap);
        }
        return aliasMap.get(clazz);
    }

    protected final void registerAlias(String alias, String property) {
        SerializationConfig.registerAlias(this.getClass(), alias, property);
    }

    protected void registerObjectUsing(Object object) {
        this.objectUsing = object;
    }

    protected void registerGlobalValidator(Validator validator) {
        this.globalValidator = validator;
    }

    protected final Map<String, String> getAliasMap() {
        return SerializationConfig.getAliasMap(this.getClass());
    }

    public static void registerAll(Class<? extends SerializationConfig> clazz) {
        Field[] fields;
        ConfigurationSerialization.registerClass(clazz);
        for (Field f : fields = clazz.getDeclaredFields()) {
            f.setAccessible(true);
            if (f.isAnnotationPresent(Property.class)) {
                Class<SerializationConfig> subclass;
                Class<?> fieldclazz = f.getType();
                if (SerializationConfig.class.isAssignableFrom(fieldclazz)) {
                    subclass = fieldclazz.asSubclass(SerializationConfig.class);
                    SerializationConfig.registerAll(subclass);
                } else if (ConfigurationSerializable.class.isAssignableFrom(fieldclazz)) {
                    subclass = fieldclazz.asSubclass(ConfigurationSerializable.class);
                    ConfigurationSerialization.registerClass(subclass);
                }
            }
            f.setAccessible(false);
        }
    }

    public static void unregisterAll(Class<? extends SerializationConfig> clazz) {
        Field[] fields;
        ConfigurationSerialization.unregisterClass(clazz);
        for (Field f : fields = clazz.getDeclaredFields()) {
            Class<?> fieldclazz;
            f.setAccessible(true);
            if (f.isAnnotationPresent(Property.class) && ConfigurationSerializable.class.isAssignableFrom(fieldclazz = f.getType())) {
                Class<ConfigurationSerializable> subclass = fieldclazz.asSubclass(ConfigurationSerializable.class);
                ConfigurationSerialization.unregisterClass(subclass);
            }
            f.setAccessible(false);
        }
    }

    public SerializationConfig() {
        this.setDefaults();
    }

    public SerializationConfig(Map<String, Object> values) {
        this.loadValues(values);
    }

    private void log(Level level, String message) {
        this.log(level, message, null);
    }

    private void log(Level level, String message, Exception e) {
        if (logger != null) {
            logger.log(level, message);
        } else if (e != null) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadValues(Map<String, Object> values) {
        Field[] fields;
        this.setDefaults();
        for (Field f : fields = this.getClass().getDeclaredFields()) {
            block9: {
                f.setAccessible(true);
                Property propertyInfo = f.getAnnotation(Property.class);
                Object serializedValue = values.get(f.getName());
                if (serializedValue != null && propertyInfo != null && (!VirtualProperty.class.isAssignableFrom(f.getType()) || propertyInfo.persistVirtual())) {
                    try {
                        Class<? extends Serializor> serializorClass = propertyInfo.serializor();
                        Serializor serializor = serializorCache.getInstance(serializorClass, this);
                        Object value = serializor.deserialize(serializedValue, SerializationConfig.getFieldType(f));
                        if (value == null) break block9;
                        if (!VirtualProperty.class.isAssignableFrom(f.getType())) {
                            f.set(this, value);
                            break block9;
                        }
                        Map<Field, Object> map = this.pendingVPropChanges;
                        synchronized (map) {
                            this.pendingVPropChanges.put(f, value);
                        }
                    }
                    catch (IllegalAccessException e) {
                        this.log(Level.WARNING, "Access exception while loading value for " + f.getName(), e);
                    }
                    catch (IllegalPropertyValueException e) {
                        this.log(Level.WARNING, "Exception while loading value for " + f.getName(), e);
                    }
                }
            }
            f.setAccessible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushPendingVPropChanges() {
        Map<Field, Object> map = this.pendingVPropChanges;
        synchronized (map) {
            for (Map.Entry<Field, Object> entry : this.pendingVPropChanges.entrySet()) {
                try {
                    entry.getKey().setAccessible(true);
                    ((VirtualProperty)entry.getKey().get(this)).set(entry.getValue());
                    entry.getKey().setAccessible(false);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            this.pendingVPropChanges.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildVPropChanges() {
        Map<Field, Object> map = this.pendingVPropChanges;
        synchronized (map) {
            if (!this.pendingVPropChanges.isEmpty()) {
                throw new IllegalStateException("pendingVPropChanges has to be empty!");
            }
            try {
                for (Field f : this.getClass().getDeclaredFields()) {
                    f.setAccessible(true);
                    if (VirtualProperty.class.isAssignableFrom(f.getType()) && f.isAnnotationPresent(Property.class) && f.getAnnotation(Property.class).persistVirtual()) {
                        this.pendingVPropChanges.put(f, ((VirtualProperty)f.get(this)).get());
                    }
                    f.setAccessible(false);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void copyValues(SerializationConfig other) {
        this.loadValues(other.serialize());
    }

    public final Map<String, Object> serialize() {
        Field[] fields = this.getClass().getDeclaredFields();
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (Field f : fields) {
            if (this.pendingVPropChanges.containsKey(f)) {
                ret.put(f.getName(), serializorCache.getInstance(f.getAnnotation(Property.class).serializor()).serialize(this.pendingVPropChanges.get(f)));
                continue;
            }
            f.setAccessible(true);
            Property propertyInfo = f.getAnnotation(Property.class);
            if (propertyInfo != null && (!VirtualProperty.class.isAssignableFrom(f.getType()) || propertyInfo.persistVirtual())) {
                try {
                    Class<? extends Serializor> serializorClass = propertyInfo.serializor();
                    Serializor serializor = serializorCache.getInstance(serializorClass, this);
                    Object raw = f.get(this);
                    if (raw instanceof VirtualProperty) {
                        raw = ((VirtualProperty)raw).get();
                    }
                    ret.put(f.getName(), serializor.serialize(raw));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            f.setAccessible(false);
        }
        return ret;
    }

    private String fixupName(String name, boolean ignoreCase) {
        if (this.getAliasMap().containsKey(name)) {
            return this.getAliasMap().get(name);
        }
        if (ignoreCase) {
            for (Map.Entry<String, String> entry : this.getAliasMap().entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(name)) continue;
                return entry.getValue();
            }
        }
        return name;
    }

    public final boolean setPropertyValue(String property, Object value) throws ClassCastException, NoSuchPropertyException {
        return this.setPropertyValue(property, value, false);
    }

    public final boolean setPropertyValue(String property, Object value, boolean ignoreCase) throws ClassCastException, NoSuchPropertyException {
        return this.setPropertyValue(property, value, ignoreCase, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean setPropertyValue(String property, Object value, boolean ignoreCase, boolean recursive) throws ClassCastException, NoSuchPropertyException {
        if (!recursive) {
            property = this.fixupName(property, ignoreCase);
        }
        try {
            boolean ret;
            String[] nodes = property.split("\\.");
            if (nodes.length == 1) {
                Field field = null;
                try {
                    field = ReflectionUtils.getField(nodes[0], this.getClass(), ignoreCase);
                    field.setAccessible(true);
                    if (field.isAnnotationPresent(Property.class)) {
                        if (!(field.getType().isAssignableFrom(value.getClass()) || field.getType().isPrimitive() || VirtualProperty.class.isAssignableFrom(field.getType()))) {
                            throw new ClassCastException(value.getClass().toString() + " cannot be cast to " + field.getType().toString());
                        }
                        Property propertyInfo = field.getAnnotation(Property.class);
                        if (!VirtualProperty.class.isAssignableFrom(field.getType())) {
                            boolean vProp = this.validateAndDoChange(field, value);
                            return vProp;
                        }
                        try {
                            value = this.validate(field, propertyInfo, value);
                        }
                        catch (ChangeDeniedException e) {
                            boolean bl = false;
                            if (field == null) return bl;
                            field.setAccessible(false);
                            return bl;
                        }
                        VirtualProperty vProp = (VirtualProperty)field.get(this);
                        vProp.set(value);
                        boolean bl = true;
                        return bl;
                    }
                    throw new MissingAnnotationException("Property");
                }
                catch (MissingAnnotationException e) {
                    throw new NoSuchPropertyException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new NoSuchPropertyException(e);
                }
                catch (ClassCastException e) {
                    throw e;
                }
                catch (Exception e) {
                    boolean vProp = false;
                    return vProp;
                }
                finally {
                    if (field != null) {
                        field.setAccessible(false);
                    }
                }
            }
            String nextNode = nodes[0];
            Field nodeField = ReflectionUtils.getField(nextNode, this.getClass(), ignoreCase);
            nodeField.setAccessible(true);
            if (!nodeField.isAnnotationPresent(Property.class)) {
                throw new Exception();
            }
            SerializationConfig child = (SerializationConfig)nodeField.get(this);
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < nodes.length; ++i) {
                sb.append(nodes[i]).append('.');
            }
            sb.deleteCharAt(sb.length() - 1);
            Exception ex = null;
            try {
                ret = child.setPropertyValue(sb.toString(), value, ignoreCase, true);
            }
            catch (Exception e) {
                ex = e;
                ret = false;
            }
            try {
                this.validate(nodeField, nodeField.getAnnotation(Property.class), child);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ex == null) return ret;
            throw ex;
        }
        catch (ClassCastException e) {
            throw e;
        }
        catch (NoSuchPropertyException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean setProperty(String property, String value) throws NoSuchPropertyException {
        return this.setProperty(property, value, false);
    }

    private static final Class<?> getFieldType(Field field) {
        if (VirtualProperty.class.isAssignableFrom(field.getType())) {
            return field.getAnnotation(Property.class).virtualType();
        }
        return field.getType();
    }

    public final boolean setProperty(String property, String value, boolean ignoreCase) throws NoSuchPropertyException {
        return this.setProperty(property, value, ignoreCase, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private final boolean setProperty(String property, String value, boolean ignoreCase, boolean recursive) throws NoSuchPropertyException {
        if (!recursive) {
            property = this.fixupName(property, ignoreCase);
        }
        try {
            boolean ret;
            String[] nodes = property.split("\\.");
            if (nodes.length == 1) {
                Field field = null;
                try {
                    field = ReflectionUtils.getField(nodes[0], this.getClass(), ignoreCase);
                    field.setAccessible(true);
                    if (field.isAnnotationPresent(Property.class)) {
                        Object oVal;
                        Property propertyInfo = field.getAnnotation(Property.class);
                        Class<? extends Serializor> serializorClass = propertyInfo.serializor();
                        Serializor serializor = serializorCache.getInstance(serializorClass, this);
                        try {
                            oVal = serializor.deserialize(value, SerializationConfig.getFieldType(field));
                        }
                        catch (IllegalPropertyValueException e) {
                            boolean bl = false;
                            if (field != null) {
                                field.setAccessible(false);
                            }
                            return bl;
                        }
                        catch (RuntimeException e) {
                            boolean bl = false;
                            if (field != null) {
                                field.setAccessible(false);
                            }
                            return bl;
                        }
                        if (VirtualProperty.class.isAssignableFrom(field.getType())) {
                            try {
                                oVal = this.validate(field, propertyInfo, oVal);
                            }
                            catch (ChangeDeniedException e) {
                                boolean bl = false;
                                if (field != null) {
                                    field.setAccessible(false);
                                }
                                return bl;
                            }
                            VirtualProperty vProp = (VirtualProperty)field.get(this);
                            vProp.set(oVal);
                            boolean bl = true;
                            return bl;
                        }
                        boolean vProp = this.validateAndDoChange(field, oVal);
                        return vProp;
                    }
                    throw new MissingAnnotationException("Property");
                    {
                        catch (MissingAnnotationException e) {
                            throw new NoSuchPropertyException(e);
                        }
                        catch (NoSuchFieldException e) {
                            throw new NoSuchPropertyException(e);
                        }
                        catch (Exception e) {
                            boolean serializorClass = false;
                            return serializorClass;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (field != null) {
                        field.setAccessible(false);
                    }
                }
            }
            String nextNode = nodes[0];
            Field nodeField = ReflectionUtils.getField(nextNode, this.getClass(), ignoreCase);
            nodeField.setAccessible(true);
            if (!nodeField.isAnnotationPresent(Property.class)) {
                throw new Exception();
            }
            SerializationConfig child = (SerializationConfig)nodeField.get(this);
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < nodes.length; ++i) {
                sb.append(nodes[i]).append('.');
            }
            sb.deleteCharAt(sb.length() - 1);
            Exception ex = null;
            try {
                ret = child.setProperty(sb.toString(), value, ignoreCase, true);
            }
            catch (Exception e) {
                ex = e;
                ret = false;
            }
            try {
                this.validate(nodeField, nodeField.getAnnotation(Property.class), child);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ex != null) {
                throw ex;
            }
            return ret;
        }
        catch (NoSuchPropertyException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
    }

    public final String getProperty(String property) throws NoSuchPropertyException {
        return this.getProperty(property, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getProperty(String property, boolean ignoreCase) throws NoSuchPropertyException {
        try {
            String[] nodes = property.split("\\.");
            if (nodes.length == 1) {
                Field field = null;
                try {
                    field = ReflectionUtils.getField(this.fixupName(nodes[0], ignoreCase), this.getClass(), ignoreCase);
                    field.setAccessible(true);
                    if (field.isAnnotationPresent(Property.class)) {
                        Object rawValue;
                        Property propertyInfo = field.getAnnotation(Property.class);
                        Class<? extends Serializor> serializorClass = propertyInfo.serializor();
                        Serializor serializor = serializorCache.getInstance(serializorClass, this);
                        if (VirtualProperty.class.isAssignableFrom(field.getType())) {
                            VirtualProperty vProp = (VirtualProperty)field.get(this);
                            rawValue = vProp.get();
                        } else {
                            rawValue = field.get(this);
                        }
                        Object serialized = serializor.serialize(rawValue);
                        String string = serialized.toString();
                        return string;
                    }
                    throw new MissingAnnotationException("Property");
                }
                catch (MissingAnnotationException e) {
                    throw new NoSuchPropertyException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new NoSuchPropertyException(e);
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    if (field != null) {
                        field.setAccessible(false);
                    }
                }
            }
            String nextNode = nodes[0];
            Field nodeField = ReflectionUtils.getField(this.fixupName(nextNode, ignoreCase), this.getClass(), ignoreCase);
            nodeField.setAccessible(true);
            if (!nodeField.isAnnotationPresent(Property.class)) {
                throw new Exception();
            }
            SerializationConfig child = (SerializationConfig)nodeField.get(this);
            StringBuilder sb = new StringBuilder();
            int i = 1;
            while (true) {
                if (i >= nodes.length) {
                    sb.deleteCharAt(sb.length() - 1);
                    return child.getProperty(sb.toString(), ignoreCase);
                }
                sb.append(nodes[i]).append('.');
                ++i;
            }
        }
        catch (NoSuchPropertyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception in getProperty(String, boolean)!", e);
        }
    }

    public final String getPropertyDescription(String property) throws NoSuchPropertyException {
        return this.getPropertyDescription(property, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getPropertyDescription(String property, boolean ignoreCase) throws NoSuchPropertyException {
        try {
            String[] nodes = property.split("\\.");
            if (nodes.length == 1) {
                Field field = null;
                try {
                    field = ReflectionUtils.getField(this.fixupName(nodes[0], ignoreCase), this.getClass(), ignoreCase);
                    field.setAccessible(true);
                    if (field.isAnnotationPresent(Property.class)) {
                        Property propertyInfo = field.getAnnotation(Property.class);
                        String string = propertyInfo.description();
                        return string;
                    }
                    throw new MissingAnnotationException("Property");
                }
                catch (MissingAnnotationException e) {
                    throw new NoSuchPropertyException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new NoSuchPropertyException(e);
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    if (field != null) {
                        field.setAccessible(false);
                    }
                }
            }
            String nextNode = nodes[0];
            Field nodeField = ReflectionUtils.getField(this.fixupName(nextNode, ignoreCase), this.getClass(), ignoreCase);
            nodeField.setAccessible(true);
            if (!nodeField.isAnnotationPresent(Property.class)) {
                throw new Exception();
            }
            SerializationConfig child = (SerializationConfig)nodeField.get(this);
            StringBuilder sb = new StringBuilder();
            int i = 1;
            while (true) {
                if (i >= nodes.length) {
                    sb.deleteCharAt(sb.length() - 1);
                    return child.getProperty(sb.toString(), ignoreCase);
                }
                sb.append(nodes[i]).append('.');
                ++i;
            }
        }
        catch (NoSuchPropertyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception in getPropertyDescription(String, boolean)!", e);
        }
    }

    protected final boolean setPropertyValueUnchecked(String property, Object value) {
        try {
            return this.setPropertyValue(property, value);
        }
        catch (NoSuchPropertyException e) {
            throw new RuntimeException(e);
        }
    }

    protected final boolean setPropertyValueUnchecked(String property, Object value, boolean ignoreCase) {
        try {
            return this.setPropertyValue(property, value, ignoreCase);
        }
        catch (NoSuchPropertyException e) {
            throw new RuntimeException(e);
        }
    }

    protected final boolean setPropertyUnchecked(String property, String value) {
        try {
            return this.setProperty(property, value);
        }
        catch (NoSuchPropertyException e) {
            throw new RuntimeException(e);
        }
    }

    protected final boolean setPropertyUnchecked(String property, String value, boolean ignoreCase) {
        try {
            return this.setProperty(property, value, ignoreCase);
        }
        catch (NoSuchPropertyException e) {
            throw new RuntimeException(e);
        }
    }

    protected final String getPropertyUnchecked(String property) {
        try {
            return this.getProperty(property);
        }
        catch (NoSuchPropertyException e) {
            throw new RuntimeException(e);
        }
    }

    protected final String getPropertyUnchecked(String property, boolean ignoreCase) {
        try {
            return this.getProperty(property, ignoreCase);
        }
        catch (NoSuchPropertyException e) {
            throw new RuntimeException(e);
        }
    }

    protected final String getPropertyDescriptionUnchecked(String property) {
        try {
            return this.getPropertyDescription(property);
        }
        catch (NoSuchPropertyException e) {
            throw new RuntimeException(e);
        }
    }

    protected final String getPropertyDescriptionUnchecked(String property, boolean ignoreCase) {
        try {
            return this.getPropertyDescription(property, ignoreCase);
        }
        catch (NoSuchPropertyException e) {
            throw new RuntimeException(e);
        }
    }

    protected void registerValidator(String fieldName, Validator validator) {
        try {
            Field field = ReflectionUtils.getField(fieldName, this.getClass(), true);
            if (field != null) {
                this.validatorMap.put(field, validator);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private Object validate(Field field, Property propertyInfo, Object newVal) throws IllegalAccessException, ChangeDeniedException {
        Validator validator = null;
        if (this.validatorMap.containsKey(field)) {
            validator = this.validatorMap.get(field);
        } else if (propertyInfo.validator() != Validator.class) {
            validator = validatorCache.getInstance(propertyInfo.validator(), this);
        } else if (this.globalValidator != null) {
            validator = this.globalValidator;
        } else if (this.getClass().isAnnotationPresent(ValidateAllWith.class)) {
            ValidateAllWith validAll = this.getClass().getAnnotation(ValidateAllWith.class);
            validator = validatorCache.getInstance(validAll.value(), this);
        }
        if (validator != null) {
            try {
                newVal = validator instanceof ObjectUsingValidator ? ((ObjectUsingValidator)validator).validateChange(field.getName(), newVal, this.getValue(field), this.objectUsing) : validator.validateChange(field.getName(), newVal, this.getValue(field));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Illegal validator!", e);
            }
        }
        return newVal;
    }

    private Object getValue(Field field) throws IllegalArgumentException, IllegalAccessException {
        if (VirtualProperty.class.isAssignableFrom(field.getType())) {
            return ((VirtualProperty)field.get(this)).get();
        }
        return field.get(this);
    }

    private <T> boolean validateAndDoChange(Field field, T newVal) throws Exception {
        if (!field.getType().isAssignableFrom(newVal.getClass()) && !field.getType().isPrimitive()) {
            return false;
        }
        Property propInfo = field.getAnnotation(Property.class);
        try {
            newVal = this.validate(field, propInfo, newVal);
        }
        catch (ChangeDeniedException e) {
            return false;
        }
        field.set(this, newVal);
        return true;
    }

    protected abstract void setDefaults();
}

