/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import me.greatman.Craftconomy.Account;
import me.greatman.Craftconomy.AccountHandler;
import me.greatman.Craftconomy.Bank;
import me.greatman.Craftconomy.BankHandler;
import me.greatman.Craftconomy.Craftconomy;
import me.greatman.Craftconomy.Currency;
import me.greatman.Craftconomy.CurrencyHandler;
import me.greatman.Craftconomy.utils.Config;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Economy_Craftconomy
implements Economy {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "Craftconomy";
    private JavaPlugin plugin = null;
    protected Craftconomy economy = null;

    public Economy_Craftconomy(JavaPlugin plugin) {
        Plugin ec;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), (Plugin)plugin);
        if (this.economy == null && (ec = plugin.getServer().getPluginManager().getPlugin("Craftconomy")) != null && ec.isEnabled() && ec.getClass().getName().equals("me.greatman.Craftconomy.Craftconomy")) {
            this.economy = (Craftconomy)ec;
            log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "Craftconomy"));
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.economy == null) {
            return false;
        }
        return this.economy.isEnabled();
    }

    @Override
    public String getName() {
        return "Craftconomy";
    }

    @Override
    public String format(double amount) {
        return Craftconomy.format((double)amount, (Currency)CurrencyHandler.getCurrency((String)Config.currencyDefault, (boolean)true));
    }

    @Override
    public String currencyNameSingular() {
        return CurrencyHandler.getCurrency((String)Config.currencyDefault, (boolean)true).getName();
    }

    @Override
    public String currencyNamePlural() {
        return CurrencyHandler.getCurrency((String)Config.currencyDefault, (boolean)true).getNamePlural();
    }

    @Override
    public double getBalance(String playerName) {
        if (AccountHandler.exists((String)playerName)) {
            return AccountHandler.getAccount((String)playerName).getDefaultBalance();
        }
        return 0.0;
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        Account account = AccountHandler.getAccount((String)playerName);
        if (account.hasEnough(amount)) {
            double balance = account.substractMoney(amount);
            return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, account.getDefaultBalance(), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        Account account = AccountHandler.getAccount((String)playerName);
        account.addMoney(amount);
        return new EconomyResponse(amount, account.getDefaultBalance(), EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        boolean success = BankHandler.create((String)name, (String)player);
        if (success) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Unable to create that bank account.");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        boolean success = BankHandler.delete((String)name);
        if (success) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Unable to create that bank account.");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        if (BankHandler.exists((String)name)) {
            Bank bank = BankHandler.getBank((String)name);
            if (bank.hasEnough(amount)) {
                return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(0.0, bank.getDefaultBalance(), EconomyResponse.ResponseType.FAILURE, "The bank does not have enough money!");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        EconomyResponse er = this.bankHas(name, amount);
        if (!er.transactionSuccess()) {
            return er;
        }
        if (BankHandler.exists((String)name)) {
            Bank bank = BankHandler.getBank((String)name);
            double balance = bank.substractMoney(amount);
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        if (BankHandler.exists((String)name)) {
            Bank bank = BankHandler.getBank((String)name);
            double balance = bank.addMoney(amount);
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        if (BankHandler.exists((String)name)) {
            Bank bank = BankHandler.getBank((String)name);
            if (bank.getOwner().equals(playerName)) {
                return new EconomyResponse(0.0, bank.getDefaultBalance(), EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "This player is not the owner of the bank!");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        EconomyResponse er = this.isBankOwner(name, playerName);
        if (er.transactionSuccess()) {
            return er;
        }
        if (BankHandler.exists((String)name)) {
            Bank bank = BankHandler.getBank((String)name);
            Iterator iterator = bank.getMembers().iterator();
            while (iterator.hasNext()) {
                if (!((String)iterator.next()).equals(playerName)) continue;
                return new EconomyResponse(0.0, bank.getDefaultBalance(), EconomyResponse.ResponseType.SUCCESS, "");
            }
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "This player is not a member of the bank!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        if (BankHandler.exists((String)name)) {
            return new EconomyResponse(0.0, BankHandler.getBank((String)name).getDefaultBalance(), EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
    }

    @Override
    public List<String> getBanks() {
        return BankHandler.listBanks();
    }

    @Override
    public boolean hasBankSupport() {
        return true;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return AccountHandler.exists((String)playerName);
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        if (AccountHandler.exists((String)playerName)) {
            return false;
        }
        AccountHandler.getAccount((String)playerName);
        return true;
    }

    public class EconomyServerListener
    implements Listener {
        Economy_Craftconomy economy = null;

        public EconomyServerListener(Economy_Craftconomy economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin ec;
            if (this.economy.economy == null && (ec = Economy_Craftconomy.this.plugin.getServer().getPluginManager().getPlugin("Craftconomy")) != null && ec.isEnabled() && ec.getClass().getName().equals("me.greatman.Craftconomy.Craftconomy")) {
                this.economy.economy = (Craftconomy)ec;
                log.info(String.format("[%s][Economy] %s hooked.", Economy_Craftconomy.this.plugin.getDescription().getName(), "Craftconomy"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("Craftconomy")) {
                this.economy.economy = null;
                log.info(String.format("[%s][Economy] %s unhooked.", Economy_Craftconomy.this.plugin.getDescription().getName(), "Craftconomy"));
            }
        }
    }
}

